	function [dmin_low,dmin_high,zout_low,zout_high] =...
	bp_find_dmin3(zstep_low,zstep_high,zatt_low,zatt_high...
	,zmin_low,zmin_high,amin_low,amin_high,Amax,NIN,NZ,q)
	% 
	% Finds the minimum distances to the specification for a 
	% bandpass filter.
	% Also the z-frequencies are found.
	% zstep = vector containing the step frequencies
	% zatt = vector containing the attenuation poles
	% zmin = vector containing the arc minimum frequencies
	% amin = vector containing the stopband attenuation requirement
	% Amax = passband ripple
	
	% Author: 			Per Loewenborg
    % Modified by:		LW
	% Copyright:		by authors - not released for commercial use
	% Version: 			1	
	% Known bugs:		None
	% Report bugs to:	larsw@isy.liu.se
	
	zout_high = [];
	dmin_high = [];
	for k = 1:length(zatt_high)
		if k == 1 
			zsub = [zstep_high(find(zstep_high <= zatt_high(1)))];
			asub = bp_sb_atten_mf([zatt_high zatt_low],NIN,NZ,q,zsub,Amax);
			temp = 0;
			for l = 1:length(zsub)
				temp(l) = asub(l)-lp_get_spec(zstep_high,amin_high,zsub(l));
			end
			[dummy,min_index] = min(temp);
			dmin_high = [dmin_high dummy];
			zout_high = [zout_high zsub(min_index)];
		else
			zsub = [zstep_high(find(and(zstep_high <= zatt_high(k)...
		    ,zstep_high > zatt_high(k-1))))...
		    zmin_high(find(and(zmin_high <= zatt_high(k)...
		    ,zmin_high > zatt_high(k-1))))];
			asub = bp_sb_atten_mf([zatt_high zatt_low],NIN,NZ,q,zsub,Amax); 
			temp = 0;
			for l = 1:length(zsub)
				temp(l) = asub(l)-lp_get_spec(zstep_high,amin_high,zsub(l));
			end
			[dummy,min_index] = min(temp);    
			dmin_high = [dmin_high dummy];
			zout_high = [zout_high zsub(min_index)];    
		end
	end 
	zsub = [zstep_high(find(zstep_high > zatt_high(length(zatt_high))))...
	zmin_high(find(zmin_high > zatt_high(k)))];
	asub = bp_sb_atten_mf([zatt_high zatt_low],NIN,NZ,q,zsub,Amax);
	temp = 0;
	for l = 1:length(zsub)
	    temp(l) = asub(l)-lp_get_spec(zstep_high,amin_high,zsub(l));
	end
	[dummy,min_index] = min(temp);   
	dmin_high = [dmin_high dummy];
	zout_high = [zout_high zsub(min_index)]; 
	
	dmin_low = [];
	zout_low = [];
	
	for k = 1:length(zatt_low)
		if k == 1
			zsub = [zstep_low(find(zstep_low < zatt_low(1)))...
		    zmin_low(find(zmin_low < zatt_low(1)))];
			asub = bp_sb_atten_mf([zatt_high zatt_low],NIN,NZ,q,zsub,Amax);
			temp = 0;
			for l = 1:length(zsub)
				temp(l) = asub(l)-lp_get_spec2(zstep_low,amin_low,zsub(l));
			end
			[dummy,min_index] = min(temp);   
			dmin_low = [dmin_low dummy];
			zout_low = [zout_low zsub(min_index)]; 
		else
			zsub = [zstep_low(find(and(zstep_low < zatt_low(k)...
		    ,zstep_low >= zatt_low(k-1))))...
		    zmin_low(find(and(zmin_low < zatt_low(k),zmin_low > zatt_low(k-1))))];
			asub = bp_sb_atten_mf([zatt_high zatt_low],NIN,NZ,q,zsub,Amax); 
			temp = 0;
			for l = 1:length(zsub)
				temp(l) = asub(l)-lp_get_spec2(zstep_low,amin_low,zsub(l));
			end
			[dummy,min_index] = min(temp);    
			dmin_low = [dmin_low dummy];
			zout_low = [zout_low zsub(min_index)];    
		end
	end 

	zsub = [zstep_low(find(zstep_low >= zatt_low(length(zatt_low))))];
	asub = bp_sb_atten_mf([zatt_high zatt_low],NIN,NZ,q,zsub,Amax);
	temp = 0;
	for l = 1:length(zsub)
		temp(l) = asub(l)-lp_get_spec2(zstep_low,amin_low,zsub(l));
	end
	[dummy,min_index] = min(temp);
	dmin_low = [dmin_low dummy];
	zout_low = [zout_low zsub(min_index)];
